function [B ,pb_corrected_roi]=ransac_plane_fit(x_roi_crop,y_roi_crop,roi_crop)
% function used for fitting a plane to the roi for planar bias correction

%% input
% x_roi_crop : x-axis values for tightly cropped roi
% y_roi_crop : y-axis values for tightly cropped roi
% roi_crop : tightly cropped region of interest(roi)
%% output
% B : coefficients of the plane fitted using ransac algorithm
% pb_corrected_roi : planar bias corrected region of interest

[rr cc]=size(roi_crop);

Xx2n=x_roi_crop.*ones([1 cc]);
Yy2n=y_roi_crop.*ones([rr 1]);

BD=roi_crop;
BD(isnan(BD))=0;
BDZ=roi_crop;

%Full_img=cat(3,Xx2n,Yy2n,BD);
%nx1 form
XTn=reshape(Xx2n,[rr*cc 1]);
YTn=reshape(Yy2n,[rr*cc 1]);
ZTn=reshape(BD,[rr*cc 1]);
Full_img=[XTn YTn ZTn];
XYZ3=Full_img;
XYZ=XYZ3';
C=[];IN={};PP={};BB={};
t=0.00002; % Distance for inlier estimation

% plane fitted to 3 sampled points
% maximum distance in m
[B, P, inliers] = ransacfitplane(XYZ,3, t, 0);
   
Z1=zeros(rr*cc,1);

TU=XYZ3;

Z1=-(((B(1)/B(3))*TU(:,1))+(B(2)/B(3))*TU(:,2)+(B(4)/B(3)));
Z2=reshape(Z1,[rr cc]);
figure;
h8=surf(Xx2n,Yy2n,BDZ);
set(h8,'edgecolor','none');
hold on;
mesh(Xx2n,Yy2n,Z2);
Z3=Z2;
Z3(BD==0)=0;

%Planar differences
Zdiff=BD-Z3;
pb_corrected_roi=Zdiff;
pb_corrected_roi(pb_corrected_roi==0)=NaN;
figure;
h9=surf(Xx2n,Yy2n,pb_corrected_roi);
set(h9,'edgecolor','none');
end
